// //
// // Pipelining function for DataTables. To be used to the `ajax` option of DataTables
// //
// $.fn.dataTable.pipeline = function (opts) {
//     // Configuration options
//     var conf = $.extend(
//         {
//             pages: 5, // number of pages to cache
//             url: '', // script url
//             data: null, // function or object with parameters to send to the server
//             // matching how `ajax.data` works in DataTables
//             method: 'GET', // Ajax HTTP method
//         },
//         opts
//     );
 
//     // Private variables for storing the cache
//     var cacheLower = -1;
//     var cacheUpper = null;
//     var cacheLastRequest = null;
//     var cacheLastJson = null;
 
//     return function (request, drawCallback, settings) {
//         var ajax = false;
//         var requestStart = request.start;
//         var drawStart = request.start;
//         var requestLength = request.length;
//         var requestEnd = requestStart + requestLength;
 
//         if (settings.clearCache) {
//             // API requested that the cache be cleared
//             ajax = true;
//             settings.clearCache = false;
//         } else if (cacheLower < 0 || requestStart < cacheLower || requestEnd > cacheUpper) {
//             // outside cached data - need to make a request
//             ajax = true;
//         } else if (
//             JSON.stringify(request.order) !== JSON.stringify(cacheLastRequest.order) ||
//             JSON.stringify(request.columns) !== JSON.stringify(cacheLastRequest.columns) ||
//             JSON.stringify(request.search) !== JSON.stringify(cacheLastRequest.search)
//         ) {
//             // properties changed (ordering, columns, searching)
//             ajax = true;
//         }
 
//         // Store the request for checking next time around
//         cacheLastRequest = $.extend(true, {}, request);
 
//         if (ajax) {
//             // Need data from the server
//             if (requestStart < cacheLower) {
//                 requestStart = requestStart - requestLength * (conf.pages - 1);
 
//                 if (requestStart < 0) {
//                     requestStart = 0;
//                 }
//             }
 
//             cacheLower = requestStart;
//             cacheUpper = requestStart + requestLength * conf.pages;
 
//             request.start = requestStart;
//             request.length = requestLength * conf.pages;
 
//             // Provide the same `data` options as DataTables.
//             if (typeof conf.data === 'function') {
//                 // As a function it is executed with the data object as an arg
//                 // for manipulation. If an object is returned, it is used as the
//                 // data object to submit
//                 var d = conf.data(request);
//                 if (d) {
//                     $.extend(request, d);
//                 }
//             } else if ($.isPlainObject(conf.data)) {
//                 // As an object, the data given extends the default
//                 $.extend(request, conf.data);
//             }
 
//             return $.ajax({
//                 type: conf.method,
//                 url: conf.url,
//                 data: request,
//                 dataType: 'json',
//                 cache: false,
//                 success: function (json) {
//                     cacheLastJson = $.extend(true, {}, json);
 
//                     if (cacheLower != drawStart) {
//                         json.data.splice(0, drawStart - cacheLower);
//                     }
//                     if (requestLength >= -1) {
//                         json.data.splice(requestLength, json.data.length);
//                     }
 
//                     drawCallback(json);
//                 },
//             });
//         } else {
//             json = $.extend(true, {}, cacheLastJson);
//             json.draw = request.draw; // Update the echo for each response
//             json.data.splice(0, requestStart - cacheLower);
//             json.data.splice(requestLength, json.data.length);
 
//             drawCallback(json);
//         }
//     };
// };
 
// // Register an API method that will empty the pipelined data, forcing an Ajax
// // fetch on the next draw (i.e. `table.clearPipeline().draw()`)
// $.fn.dataTable.Api.register('clearPipeline()', function () {
//     return this.iterator('table', function (settings) {
//         settings.clearCache = true;
//     });
// });

$(document).ready( function (){
    var table = $('#myTable').DataTable({
        "processing": true,
        "serverSide": true,
        //"deferLoading": 200,
        "ajax": "model/show_products.php",
        // "ajax": 
        //     $.fn.dataTable.pipeline({
        //     url: 'product_manager/show_products.php',
        //     pages: 5, // number of pages to cache
        //     }),
        "columnDefs": [
            {
                "targets": 12,
                "data": 1,
                "mRender": function(data, type, full) {
                    return "<button type='button' class='btn btn-info btn-sm' data-toggle='modal' data-target='#myModal_1' id='"+data+"'>Calculate</button>";
                }
                
            },

            // {
            //     "targets": 10, 
            //     "render": function ( data, type, row ) {
            //         if (sessionStorage.getItem("selected") === 'JOHNSON & JOHNSON VISION' || sessionStorage.getItem("selected") === 'KATENA') {return data = 'N/A';}
            //         else return data;
            //     }
            // },
            // {
            //     "targets": 9, 
            //     "render": function ( data, type, row ) {
            //         if (sessionStorage.getItem("selected") === 'KATENA') {return data = 'N/A';}
            //         else return data;
            //     }
            // },
            // {
            //     "targets": 8, 
            //     "render": function ( data, type, row ) {
            //         if (sessionStorage.getItem("selected") === 'KATENA') {return data = 'N/A';}
            //         else return data;
            //     }
            // },
        ],
        "language": {
            processing: '<i class="fa fa-spinner fa-spin fa-3x fa-fw"></i><span class="sr-only">Loading...</span> '},
        "pageLength": 10,
        "searching": true,
        "columns": [
            null,
            { "searchable": false },
            null,
            null,
            null,
            { "searchable": false },
            { "searchable": false },
            { "searchable": false },
            { "searchable": false },
            { "searchable": false },
            { "searchable": false },
            { "searchable": false }
        ]
    });
    // $('.filter').on('keyup change', function() {
    //     table.columns([2,3]).search($(this).val()).draw();
    // });

    //   $(".dataTables_filter input").on('keyup change', function() {
    //     //clear column search values
    //     table.columns().search('');
    //     //clear input values
    //     $('.filter').val('');
    //   });
    //handle vendors selection
    var selectedProduct = sessionStorage.getItem("selected");
    $('#vendors').first().find(":selected").removeAttr("selected");
    $('#vendors').find("option").each(function () {
         if ($(this).val() == selectedProduct) {
             $(this).attr("selected", true);
         }
    });
    table.column(0).search(sessionStorage.getItem("selected")).draw();   
    var vendor = $('#vendors').find(":selected").text().trim();
    var img = document.getElementById('img');
    if (vendor === 'Vendors') {
         img.src = '';
         table.column(0).search("").draw();
         table.column(4).search("").draw();
         document.getElementById('mainCategory').value = '';
    }
    else {
         for (var i=0; i<links.length; i++) {
             if (links[i][0] === vendor) {
                 img.src = links[i][1];
             }
         }
    }
    $('#mainCategory').on('change', function(){
         table.column(4).search(this.value).draw();   
     });
    $('#vendors').on('change', function(){
        document.getElementById('formVendor').submit();
        sessionStorage.setItem('selected', $('#vendors').first().val());
    });
    $('#myTable tbody').on( 'click', 'tr', function () {
        if ( $(this).hasClass('selected') ) {
            $(this).removeClass('selected');
        } 
        else {
            table.$('tr.selected').removeClass('selected');
            $(this).addClass('selected');
            document.getElementById('facility').value = "";
            document.getElementById('usage').value = "";
            document.getElementById('difference').value = "";
            document.getElementById('percent').value = "";
            document.getElementById('savings').value = "";
            var data = $('#myTable').DataTable().row('.selected').data();
            document.getElementById('vendor').value = data[0];
            document.getElementById('sku').value = data[2];
            document.getElementById('desc').value = data[3];
            document.getElementById('quantity').value = data[7];
            document.getElementById('tier').getElementsByTagName('option')[0].selected = 'selected';
            document.getElementById('tierPrice').value = data[8];
            var unit = 0;
            unit = Number(document.getElementById('tierPrice').value)/Number(document.getElementById('quantity').value);
            unit = unit.toFixed(2);
            document.getElementById('unit').value = unit;
        }

        // if (sessionStorage.getItem("selected") === 'JOHNSON & JOHNSON VISION') {
        //     $("#tier4").prop('disabled', true);
        // }
        // else if (sessionStorage.getItem("selected") === 'KATENA') {
        //     $("#tier2").prop('disabled', true);
        //     $("#tier3").prop('disabled', true);
        //     $("#tier4").prop('disabled', true);
        // }
        // else {
        //     $("#tier2").prop('disabled', false);
        //     $("#tier3").prop('disabled', false);
        //     $("#tier4").prop('disabled', false);
        // }
    });
    // $('#myFilter1').on('keyup', function(){
    //     table.columns(1).clearPipeline().search($(this).val()).draw();
    //     // $('#myFilter2').val('');
    // });
    // $('#myFilter2').on('keyup', function(){
    //     table.columns(2).clearPipeline().search($(this).val()).draw();
        //$('#myFilter1').val('');
    //});
    // $('#searchButton').on('click', function(){
    //      table.columns([1]).clearPipeline().search($('#myFilter1').val()).draw();
    //     //$('#myFilter2').val('');
    // });
    //  $('#myFilter2').on('keyup', function(){
    //      table.columns([2]).clearPipeline().search($(this).val()).draw();
    //      $('#myFilter1').val('');
    //  });
});
function Unit() {
    var data = $('#myTable').DataTable().row('.selected').data();
    if (document.getElementById('tier').value === 'tier1') {
        document.getElementById('tierPrice').value = data[8];
    }
    else if (document.getElementById('tier').value === 'tier2') {
        document.getElementById('tierPrice').value = data[9];
    }
    else if (document.getElementById('tier').value === 'tier3') {
        document.getElementById('tierPrice').value = data[10];
    }
    else {
        document.getElementById('tierPrice').value = data[111];
    }
    document.getElementById('facility').value = "";
    document.getElementById('difference').value = "";
    document.getElementById('percent').value = "";
    document.getElementById('usage').value = "";
    document.getElementById('savings').value = "";
    if (document.getElementById('tierPrice').value !== '') {
        var unit = 0;
        unit =  Number(document.getElementById('tierPrice').value)/Number(document.getElementById('quantity').value);
        unit = unit.toFixed(2);
        document.getElementById('unit').value = unit;
        $("#facility").prop('disabled', false);
    }
    else {
        $("#facility").prop('disabled', true);
    }
}
function Calc1() {
    if (event.key === 'Enter'){
        var facility = document.getElementById('facility').value;
        var difference = 0;
        var percent = 0;
        var tier = document.getElementById('tierPrice').value;
        difference = facility - Number(tier);
        percent = (difference/facility)*100;
        document.getElementById('difference').value = difference.toFixed(2);
        document.getElementById('percent').value = percent.toFixed(2);
        $('#usage').prop('disabled', false);
        $('#usage').focus();
    }
}
function Calc2() {
    if (event.key === 'Enter'){
        // if (document.getElementById('savings').value !== '') {
        //     $("#submit").click()
        // }
        // else {
            var usage = document.getElementById('usage').value;
            var difference = document.getElementById('difference').value; 
            var savings = 0;
            savings = usage * difference;
            document.getElementById('savings').value = savings.toFixed(2);
        // }
        if (document.getElementById('savings').value > 0) {
            document.getElementById('savings').style.color = 'green';
        }
        else if (document.getElementById('savings').value < 0) {
            document.getElementById('savings').style.color = 'red';
        }
    }
}
function Submit() {
    if (document.getElementById('facility').value === '') {
        alert ('Please input Facility Pricing!');
    }
    else if (document.getElementById('usage').value === '') {
        alert ('Please input Annual Usage!');
    }
    else {
        var pro = document.getElementById('myModalTable');
        var pro1 = document.getElementById('myModalTable1');
        let dollarUS = Intl.NumberFormat("en-US", {
            style: "currency",
            currency: "USD",
            useGrouping: true,
        });
        var totalSavings = [{vendor: document.getElementById('vendor').value, sku: document.getElementById('sku').value, desc: document.getElementById('desc').value, quantity: document.getElementById('quantity').value, tier: document.getElementById('tier').value, tierPricing: document.getElementById('tierPrice').value, unit: document.getElementById('unit').value, facility: document.getElementById('facility').value, usage: document.getElementById('usage').value, difference: document.getElementById('difference').value, percent: document.getElementById('percent').value, savings: document.getElementById('savings').value}];
        if(sessionStorage.getItem('totalSavings') !== null) {
            var retrievedTotal = JSON.parse(sessionStorage.getItem('totalSavings'));
            for (var m = 0; m < retrievedTotal.length; m++) {
                if (totalSavings[0].vendor === retrievedTotal[m].vendor) {
                    if (totalSavings[0].sku === retrievedTotal[m].sku) {
                        retrievedTotal[m].savings = totalSavings[0].savings;
                        break;
                    }
                    else {
                        retrievedTotal.push(totalSavings[0]);
                        break;
                    }
                }
                else {
                    retrievedTotal.push(totalSavings[0]);
                    break;
                }
            }
            sessionStorage.setItem('totalSavings', JSON.stringify(retrievedTotal));
        }
        else {
            sessionStorage.setItem('totalSavings', JSON.stringify(totalSavings));
        }
        var totals = JSON.parse(sessionStorage.getItem('totalSavings'));
        var totalsavings = 0;
        pro.innerHTML = "<tr class='productTable'>"
                        +'<th>Vendor</th>'
                        +'<th>SKU</th>'
                        +'<th>Description</th>'
                        +'<th>Quantity</th>'
                        +'<th>Tier</th>'
                        +'<th>Tier Pricing</th>'
                        +'<th>Tier Pricing per Unit</th>'
                        +'<th>Facility Pricing</th>'
                        +'<th>Annual Usage</th>'
                        +'<th>Difference</th>'
                        +'<th>% Savings</th>'
                        +'<th>Savings</th>'
                        +'</tr>';
        for (var n = 0; n < totals.length; n++) {
            totalsavings = totalsavings + Number(totals[n].savings);
            pro.innerHTML += "<tr class='productTable'>" + "<td>" + totals[n].vendor + "</td>" + "<td>" +  totals[n].sku + "</td>" + "<td>" + totals[n].desc + "</td>" + "<td>" +  totals[n].quantity + "</td>" + "<td>" +  totals[n].tier + "</td>" + "<td>" +  totals[n].tierPricing + "</td>" + "<td>" +  totals[n].unit + "</td>" + "<td>" +  totals[n].facility + "</td>" + "<td>" +  totals[n].usage + "</td>" + "<td>" +  totals[n].difference + "</td>" + "<td>" +  totals[n].percent + "</td>" + "<td>" + totals[n].savings + "</td>" + "</tr>";
        }
        totalsavings = dollarUS.format(totalsavings);
        document.getElementById('totalSavings').innerHTML = 'Total Savings: ' + totalsavings;
        document.getElementById('myModalTable').innerHTML = pro.innerHTML;
        sessionStorage.setItem('modal', pro.innerHTML);
        sessionStorage.setItem('totalsavings', totalsavings);
                        
        var vendorAggregates = {};
        for (var n = 0; n < totals.length; n++) {
            var vendor = totals[n].vendor;
            var facility = Number(totals[n].facility) * Number(totals[n].usage);
            var eyepro = Number(totals[n].tierPricing) * Number(totals[n].usage);
            var savings = Number(totals[n].savings);
        
            // Check if the vendor already exists in the aggregates object
            if (vendor in vendorAggregates) {
                // If it exists, update the aggregates for that vendor
                vendorAggregates[vendor].facility += facility;
                vendorAggregates[vendor].eyepro += eyepro;
                vendorAggregates[vendor].savings += savings;
            } else {
                // If it doesn't exist, initialize the aggregates for that vendor
                vendorAggregates[vendor] = {
                    facility: facility,
                    eyepro: eyepro,
                    savings: savings,
                };
            }
        }
        
        // Convert the vendor aggregates object into an array of objects
        var array = [];
        pro1.innerHTML = "<tr class='vendorTable'>"
        + "<th>Vendor</th>"
        +"<th>Facility Total</th>"
        +"<th>EyeProGPO Total</th>"
        + "<th>Total Savings</th>"
        + "</tr>";
        for (var vendor in vendorAggregates) {
            array.push({
                vendor: vendor,
                facility: vendorAggregates[vendor].facility.toFixed(2),
                eyepro: vendorAggregates[vendor].eyepro.toFixed(2),
                totalsavings: (Number(vendorAggregates[vendor].savings)).toFixed(2),
            });
        }
        for (var s=0; s<array.length; s++) {
            pro1.innerHTML += "<tr class='vendorTable'>" + "<td>" + array[s].vendor + "</td>" + "<td>" + array[s].facility + "</td>" + "<td>" + array[s].eyepro + "</td>" + "<td>" + array[s].totalsavings + "</td>" + "</tr>";
        }
        document.getElementById('myModalTable1').innerHTML = pro1.innerHTML;
        sessionStorage.setItem('modal1', pro1.innerHTML);
        
        document.getElementById('close').click();    
    }

}
function CSV1() {
    // Variable to store the final csv data
    var csv_data = [];
 
    // Get each row data
    var rows = document.getElementsByClassName('productTable');
    for (var i = 0; i < rows.length; i++) {
 
        // Get each column data
        var cols = rows[i].querySelectorAll('td,th');
 
        // Stores each csv row data
        var csvrow = [];
        for (var j = 0; j < cols.length; j++) {
 
            // Get the text data of each cell of
            // a row and push it to csvrow
            csvrow.push(cols[j].innerHTML);
        }
 
        // Combine each column value with comma
        csv_data.push(csvrow.join(","));
    }
    // combine each row data with new line character
    csv_data = csv_data.join('\n');
        // Create CSV file object and feed our
    // csv_data into it
    CSVFile = new Blob([csv_data], { type: "text/csv" });
 
    // Create to temporary link to initiate
    // download process
    var temp_link = document.createElement('a');
 
    // Download csv file
    temp_link.download = "Savings by Products.csv";
    var url = window.URL.createObjectURL(CSVFile);
    temp_link.href = url;
 
    // This link should not be displayed
    temp_link.style.display = "none";
    document.body.appendChild(temp_link);
 
    // Automatically click the link to trigger download
    temp_link.click();
    document.body.removeChild(temp_link);
}

function CSV2() {
    // Variable to store the final csv data
    var csv_data = [];
 
    // Get each row data
    var rows = document.getElementsByClassName('vendorTable');
    for (var i = 0; i < rows.length; i++) {
 
        // Get each column data
        var cols = rows[i].querySelectorAll('td,th');
 
        // Stores each csv row data
        var csvrow = [];
        for (var j = 0; j < cols.length; j++) {
 
            // Get the text data of each cell of
            // a row and push it to csvrow
            csvrow.push(cols[j].innerHTML);
        }
 
        // Combine each column value with comma
        csv_data.push(csvrow.join(","));
    }
    // combine each row data with new line character
    csv_data = csv_data.join('\n');
        // Create CSV file object and feed our
    // csv_data into it
    CSVFile = new Blob([csv_data], { type: "text/csv" });
 
    // Create to temporary link to initiate
    // download process
    var temp_link = document.createElement('a');
 
    // Download csv file
    temp_link.download = "Savings by Vendors.csv";
    var url = window.URL.createObjectURL(CSVFile);
    temp_link.href = url;
 
    // This link should not be displayed
    temp_link.style.display = "none";
    document.body.appendChild(temp_link);
 
    // Automatically click the link to trigger download
    temp_link.click();
    document.body.removeChild(temp_link);
}
function ClearFilter() {
    $('#myFilter1').val('');
    $('#myFilter2').val('');
    location.reload();
}