// //
// // Pipelining function for DataTables. To be used to the `ajax` option of DataTables
// //
// $.fn.dataTable.pipeline = function (opts) {
//     // Configuration options
//     var conf = $.extend(
//         {
//             pages: 5, // number of pages to cache
//             url: '', // script url
//             data: null, // function or object with parameters to send to the server
//             // matching how `ajax.data` works in DataTables
//             method: 'GET', // Ajax HTTP method
//         },
//         opts
//     );
 
//     // Private variables for storing the cache
//     var cacheLower = -1;
//     var cacheUpper = null;
//     var cacheLastRequest = null;
//     var cacheLastJson = null;
 
//     return function (request, drawCallback, settings) {
//         var ajax = false;
//         var requestStart = request.start;
//         var drawStart = request.start;
//         var requestLength = request.length;
//         var requestEnd = requestStart + requestLength;
 
//         if (settings.clearCache) {
//             // API requested that the cache be cleared
//             ajax = true;
//             settings.clearCache = false;
//         } else if (cacheLower < 0 || requestStart < cacheLower || requestEnd > cacheUpper) {
//             // outside cached data - need to make a request
//             ajax = true;
//         } else if (
//             JSON.stringify(request.order) !== JSON.stringify(cacheLastRequest.order) ||
//             JSON.stringify(request.columns) !== JSON.stringify(cacheLastRequest.columns) ||
//             JSON.stringify(request.search) !== JSON.stringify(cacheLastRequest.search)
//         ) {
//             // properties changed (ordering, columns, searching)
//             ajax = true;
//         }
 
//         // Store the request for checking next time around
//         cacheLastRequest = $.extend(true, {}, request);
 
//         if (ajax) {
//             // Need data from the server
//             if (requestStart < cacheLower) {
//                 requestStart = requestStart - requestLength * (conf.pages - 1);
 
//                 if (requestStart < 0) {
//                     requestStart = 0;
//                 }
//             }
 
//             cacheLower = requestStart;
//             cacheUpper = requestStart + requestLength * conf.pages;
 
//             request.start = requestStart;
//             request.length = requestLength * conf.pages;
 
//             // Provide the same `data` options as DataTables.
//             if (typeof conf.data === 'function') {
//                 // As a function it is executed with the data object as an arg
//                 // for manipulation. If an object is returned, it is used as the
//                 // data object to submit
//                 var d = conf.data(request);
//                 if (d) {
//                     $.extend(request, d);
//                 }
//             } else if ($.isPlainObject(conf.data)) {
//                 // As an object, the data given extends the default
//                 $.extend(request, conf.data);
//             }
 
//             return $.ajax({
//                 type: conf.method,
//                 url: conf.url,
//                 data: request,
//                 dataType: 'json',
//                 cache: false,
//                 success: function (json) {
//                     cacheLastJson = $.extend(true, {}, json);
 
//                     if (cacheLower != drawStart) {
//                         json.data.splice(0, drawStart - cacheLower);
//                     }
//                     if (requestLength >= -1) {
//                         json.data.splice(requestLength, json.data.length);
//                     }
 
//                     drawCallback(json);
//                 },
//             });
//         } else {
//             json = $.extend(true, {}, cacheLastJson);
//             json.draw = request.draw; // Update the echo for each response
//             json.data.splice(0, requestStart - cacheLower);
//             json.data.splice(requestLength, json.data.length);
 
//             drawCallback(json);
//         }
//     };
// };
 
// // Register an API method that will empty the pipelined data, forcing an Ajax
// // fetch on the next draw (i.e. `table.clearPipeline().draw()`)
// $.fn.dataTable.Api.register('clearPipeline()', function () {
//     return this.iterator('table', function (settings) {
//         settings.clearCache = true;
//     });
// });


$(document).ready( function (){
    var table = $('#myTable').DataTable({
        "searching": true,
        "processing": true,
        "serverSide": true,
        "ajax": "model/show_products2.php",
    //   "ajax": 
    //         $.fn.dataTable.pipeline({
    //         url: 'product_manager/show_products2.php',
    //         pages: 5, // number of pages to cache
    //         }),
        "columnDefs": [
            {
               "targets": 13,
                "mRender": function(data, type, full) {
                    return '<button type="button" class="btn btn-info btn-sm" data-toggle="modal" data-target="#myModal_2" id="selectEdit">Edit</button>';
                }
                
            },
             {
                'targets': [0],
                'visible': false
            },
            // {
            //     "targets": 10, 
            //     "render": function ( data, type, row ) {
            //         if (sessionStorage.getItem("selected") === 'JOHNSON & JOHNSON VISION' || sessionStorage.getItem("selected") === 'KATENA') {return data = 'N/A';}
            //         else return data;
            //     }
            // },
            // {
            //     "targets": 9, 
            //     "render": function ( data, type, row ) {
            //         if (sessionStorage.getItem("selected") === 'KATENA') {return data = 'N/A';}
            //         else return data;
            //     }
            // },
            // {
            //     "targets": 8, 
            //     "render": function ( data, type, row ) {
            //         if (sessionStorage.getItem("selected") === 'KATENA') {return data = 'N/A';}
            //         else return data;
            //     }
            // },
        ],
        "language": {
            processing: '<i class="fa fa-spinner fa-spin fa-3x fa-fw"></i><span class="sr-only">Loading...</span> '},
        "pageLength": 10,
        "columns": [
            null,
            null,
            null,
            null,
            null,
            { "searchable": false },
            { "searchable": false },
            { "searchable": false },
            { "searchable": false },
            { "searchable": false },
            { "searchable": false },
            { "searchable": false },
            { "searchable": false },
            { "searchable": false }
        ]
    });
    //handle vendors selection
    var selectedProduct = sessionStorage.getItem("selected2");
    $('#vendors').first().find(":selected").removeAttr("selected");
    $('#vendors').find("option").each(function () {
         if ($(this).val() == selectedProduct) {
             $(this).attr("selected", true);
         }
    });
    table.column(1).search(sessionStorage.getItem("selected2")).draw();   
    var vendor = $('#vendors').find(":selected").text().trim();
    var img = document.getElementById('img');
    if (vendor === 'Vendors') {
         img.src = '';
         table.column(1).search("").draw();
         table.column(4).search("").draw();
         document.getElementById('mainCategory').value = '';
    }
    else {
         for (var i=0; i<links.length; i++) {
             if (links[i][0] === vendor) {
                 img.src = links[i][1];
             }
         }
    }
    $('#mainCategory').on('change', function(){
         table.column(4).search(this.value).draw();   
     });
    $('#vendors').on('change', function(){
        document.getElementById('formVendor').submit();
        sessionStorage.setItem('selected2', $('#vendors').first().val());
    });
    $('#myTable tbody').on( 'click', 'tr', function () {
        if ( $(this).hasClass('selected') ) {
            $(this).removeClass('selected');
        } 
        else {
            //document.getElementById('name').value = name[0];
            table.$('tr.selected').removeClass('selected');
            $(this).addClass('selected');
            var data = $('#myTable').DataTable().row('.selected').data();
            document.getElementById('ID').value = data[0];
            document.getElementById('vendor').value = data[1];
            document.getElementById('sku').value = data[2];
            document.getElementById('oldVendor').value = data[1];
            document.getElementById('oldSku').value = data[2];
            document.getElementById('description').value = data[3];
            document.getElementById('oldDescription').value = data[3];
            document.querySelector('#uom').value = data[6];
            document.getElementById('oldUoM').value = data[6];
            document.getElementById('qty').value = data[7];
            document.getElementById('oldQty').value = data[7];
            document.getElementById('tierPrice').value = data[8];
            document.getElementById('active').value = data[12];
            if(document.getElementById('active').value === '1'){
                document.getElementById('active').checked = true;
            }
            else{
                document.getElementById('active').checked = false;
            }
            document.getElementById('oldActive').value = data[12];
            document.getElementById('oldTier1').value = data[8];
            document.getElementById('oldTier2').value = data[9];
            document.getElementById('oldTier3').value = data[10];
            document.getElementById('oldTier4').value = data[11];
        }
    });
});
function Unit() {
    var data = $('#myTable').DataTable().row('.selected').data();
    console.log(data[9]);
    if (document.getElementById('tier').value === 'TIER 1') {
        document.getElementById('tierPrice').value = data[8];
    }
    else if (document.getElementById('tier').value === 'TIER 2') {
        document.getElementById('tierPrice').value = data[9];
    }
    else if (document.getElementById('tier').value === 'TIER 3') {
        document.getElementById('tierPrice').value = data[10];
    }
    else {
        document.getElementById('tierPrice').value = data[11];
    }
    // var unit = 0;
    // unit =  Number(document.getElementById('tierPrice').value)/Number(document.getElementById('quantity').value);
    // unit = unit.toFixed(2);
    // document.getElementById('unit').value = unit;
    // if (document.getElementById('tierPrice').value !== '') {
    //     $("#facility").prop('disabled', false);
    // }
    // else {
    //     $("#facility").prop('disabled', true);
    // }
}
function Active() {
    if(document.getElementById('active').value === '1'){
        document.getElementById('active').value = '0';
    }
    else {
        document.getElementById('active').value = '1';
    }
}
function Submit2() {
    document.getElementById("submitButton").click();
}
