$(document).ready(function () {
    var table = $('#myTable').DataTable({
        "scrollY": 300,
        "paging": true,
        "searching": true,
        "processing": true,
        "serverSide": true,
        "ajax": "model/show_products.php",
        "dom": 'Bfrtip',
        "buttons": [
            'excelHtml5', 'csvHtml5'
        ],
        "language": {
            processing: '<i class="fa fa-spinner fa-spin fa-3x fa-fw"></i><span class="sr-only">Loading...</span> '},
        "columns": [
            null,
            { "searchable": false },
            null,
            null,
            null,
            { "searchable": false },
            { "searchable": false },
            { "searchable": false },
            { "searchable": false },
            { "searchable": false },
            { "searchable": false },
            { "searchable": false }
        ],
        "pageLength": 10000
    });
    var selectedProduct = sessionStorage.getItem("selected3");
    $('#vendors').first().find(":selected").removeAttr("selected");
    $('#vendors').find("option").each(function () {
         if ($(this).val() == selectedProduct) {
             $(this).attr("selected", true);
         }
    });
    table.column(0).search(sessionStorage.getItem("selected3")).draw();   
    var vendor = $('#vendors').find(":selected").text().trim();
    var img = document.getElementById('img');
    if (vendor === 'Vendors') {
         img.src = '';
         table.column(0).search("").draw();
         table.column(4).search("").draw();
         document.getElementById('mainCategory').value = '';
    }
    else {
         for (var i=0; i<links.length; i++) {
             if (links[i][0] === vendor) {
                 img.src = links[i][1];
             }
         }
    }
    $('#mainCategory').on('change', function(){
         table.column(4).search(this.value).draw();   
     });
    $('#vendors').on('change', function(){
        document.getElementById('formVendor').submit();
        sessionStorage.setItem('selected3', $('#vendors').first().val());
    });

});