<?php
function get_all_vendors() {
    global $db;
    $query = 'SELECT vendor
              FROM eyepro_db.vendors_view
              WHERE vendor != "EYEPOINT"
              AND vendor != "EYEPRO GPO"
              AND vendor != "CORNEAGEN"
              ORDER BY vendor ASC;';
    $statement = $db->prepare($query);
    $statement->execute();
    $vendors = $statement->fetchAll();
    $statement->closeCursor();
    return $vendors;
}

function get_img() {
    global $db;
    $query = 'SELECT * FROM eyepro_db.vendors_view';
    $statement = $db->prepare($query);
    $statement->execute();
    $images = $statement->fetchAll();
    $statement->closeCursor();
    return $images;
}

function get_all_categories_by_vendor($vendor) {
    global $db;
    $query = 'SELECT * FROM eyepro_db.categories_view 
              WHERE vendor = :vendor
              ORDER BY category ASC;';
    $statement = $db->prepare($query);
    $statement->bindValue(':vendor', $vendor);
    $statement->execute();
    $category = $statement->fetchAll();
    $statement->closeCursor();
    return $category;
}

function get_all_categories() {
    global $db;
    $query = 'SELECT DISTINCT(category) FROM eyepro_db.categories_view
              ORDER BY category ASC;';
    $statement = $db->prepare($query);
    $statement->execute();
    $category = $statement->fetchAll();
    $statement->closeCursor();
    return $category;
}
function update_product($product_id, $description, $uom, $qty, $active) {
    global $db;
    $query = 'UPDATE eyepro_db.products, eyepro_db.products_has_vendors 
              SET products.description = :description, products_has_vendors.uom = :uom, products_has_vendors.units_in_uom = :units_in_uom, products_has_vendors.active = :active
              WHERE products.product_id = products_has_vendors.products_product_id 
              AND products.product_id = :product_id';
    $statement = $db->prepare($query);
    $statement ->bindValue(':product_id', $product_id);
    $statement ->bindValue(':description', $description);
    $statement ->bindValue(':uom', $uom);
    $statement ->bindValue(':units_in_uom', $qty);
    $statement ->bindValue(':active', $active);
    $statement ->execute();
    $statement ->closeCursor(); 
}

function update_price($product_id, $tier, $price) {
    global $db;
    $query = 'UPDATE eyepro_db.tiers, eyepro_db.products_has_vendors 
              SET products_has_vendors.price = :price
              WHERE tiers.tier_id = products_has_vendors.tiers_tier_id
              AND tiers.tier_name = :tier_name
              AND products_has_vendors.products_product_id = :product_id';
    $statement = $db->prepare($query);
    $statement ->bindValue(':product_id', $product_id);
    $statement ->bindValue(':tier_name', $tier);
    $statement ->bindValue(':price', $price);
    $statement ->execute();
    $statement ->closeCursor(); 
}

function add_product($productID, $vendor, $sku, $desc, $uom, $qty, $tier1, $tier2, $tier3, $tier4, $active, $datetime, $name, $note) {
    global $db;
    $query = 'INSERT INTO eyepro_db.edit_notification
                 (ProductID, Vendor, SKU, Description, UoM, Qty, Tier1, Tier2, Tier3, Tier4, Active, DateTime, Name, Note)
              VALUES
                 (:productID, :vendor, :sku, :desc, :uom, :qty, :tier1, :tier2, :tier3, :tier4, :active, :datetime, :name, :note)';
    $statement = $db->prepare($query);
    $statement->bindValue(':productID', $productID);
    $statement->bindValue(':vendor', $vendor);
    $statement->bindValue(':sku', $sku);
    $statement->bindValue(':desc', $desc);
    $statement->bindValue(':uom', $uom);
    $statement->bindValue(':qty', $qty);
    $statement->bindValue(':tier1', $tier1);
    $statement->bindValue(':tier2', $tier2);
    $statement->bindValue(':tier3', $tier3);
    $statement->bindValue(':tier4', $tier4);
    $statement->bindValue(':active', $active);
    $statement->bindValue(':datetime', $datetime);
    $statement->bindValue(':name', $name);
    $statement->bindValue(':note', $note);
    $statement->execute();
    $statement->closeCursor();
}